/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(sin(time*0.77777),sin(time*0.55555))
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

//---------------------------------------------------------
// Shader:   WaterTurbulence.glsl
// WaterTurbulence by joltz0r 2013-07-07
// http://glslsandbox.com/e#22111.0
// mouse zooming added by I.G.P.  2015-01-12
//---------------------------------------------------------

#ifdef GL_ES
  precision highp float;
#endif

// uniform float time;
// uniform vec3 mouse;
// uniform vec2 resolution;

//---------------------------------------------------------
#define MAX_ITER 10
#define ITENSITY 0.1

vec3 blue = vec3(0.25, .55, 1.3);

void main( void ) 
{
  vec2 p = -1.0 + 2.0 * scaled_gl_FragCoord.xy / resolution.xy; //normalize position and make 0,0 screen center
  p *= 6.0 * (0.4 + mouse.y / resolution.y); // p multiplied by (2.4 -> 8.4);
  vec2 i = p;
  float c = 0.0;

  for (int n = 0; n < MAX_ITER; n++) 
  {
    float t = time * (1.0 - (1.0 / float(n+1))); // starts at 0.5 * time and tends to time with each iteration
    i = p + vec2( cos(t - i.x) + sin(t + i.x),  //shit gets tricky here
                  sin(t - i.y) + cos(t + i.x));

   c += 2.0 / length(vec2( (sin(i.x + t) / ITENSITY),
                            (cos(i.y + t) / ITENSITY)));
  }
  c /= float(MAX_ITER);
  gl_FragColor = vec4(c*blue, 1.0);
  gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}